% FOR HELICOPTER NR 3-10
% This file contains the initialization for the helicopter assignment in
% the course TTK4115. Run this file before you execute QuaRC_ -> Build 
% to build the file heli_q8.mdl.

% Oppdatert hsten 2006 av Jostein Bakkeheim
% Oppdatert hsten 2008 av Arnfinn Aas Eielsen
% Oppdatert hsten 2009 av Jonathan Ronen
% Updated fall 2010, Dominik Breu
% Updated fall 2013, Mark Haring
% Updated spring 2015, Mark Haring


%%%%%%%%%%% Calibration of the encoder and the hardware for the specific
%%%%%%%%%%% helicopter
Joystick_gain_x = 0.7;
Joystick_gain_y = 0.7;


%%%%%%%%%%% Physical constants
g = 9.81; % gravitational constant [m/s^2]
l_c = 0.46; % distance elevation axis to counterweight [m]
l_h = 0.66; % distance elevation axis to helicopter head [m]
l_p = 0.175; % distance pitch axis to motor [m]
m_c = 1.92; % Counterweight mass [kg]
m_p = 0.72; % Motor mass [kg]

%%%%%%%%%%% Constants found at the lab
e_offset = -0.454;

vs_0 = 7.2;

p_offset = 0;

k_f = -(m_c*g*l_c - 2*m_p*g*l_h)/(vs_0*l_h);

j_p = 2 * m_p * l_p^2;
j_e = m_c * l_c^2 + 2 * m_p * l_h^2;
j_l = m_c * l_c^2 + 2 * m_p * (l_h^2 + l_p^2);

k_1 = l_p * k_f /j_p;

k_2 = l_h * k_f / j_e;

k_3 = (l_h* k_f) / j_l;

%%%%%%%%%%% LQR Regulator
A = [
  [ 0  1  0  0  0];
  [ 0  0  0  0  0];
  [ 0  0  0  0  0];
  [-1  0  0  0  0];
  [ 0  0 -1  0  0];
];

B = [
  [  0   0];
  [  0 k_1];
  [k_2   0];
  [  0   0];
  [  0   0];
];

%C = [
%  [0 1 0];
%  [0 0 1];
%];

% Q11 = Pitch error straff (hyere verdi gir tillater mere pitch)
% Q22 = Pitch rate error straff (hyere verdi gir mere demping p pitch)
% Q33 = Elevation rate?
% Q44 = Pitch integral?
% Q55 = Elevation integral?

Q = diag([1000 500 500 50 100]);

R = diag([1 1]);

K = lqr(A, B, Q, R);

%F = inv(C*inv(B*K-A)*B)

F = [
   [K(1, 1) K(1, 3)];
   [K(2, 1) K(2, 3)];
]; % ?????

% Input control
x_unit_step_length = 3;
x_unit_step_start_time = 6;
x_unit_step_gain = 0;

y_unit_step_length = 4.9 ;
y_unit_step_start_time = 0;
y_unit_step_gain = 0.50;

unit_input_disable_delay = 10;

% IMU Config
PORT = 4;


% Luenberger Observer

radius = min(eig(A-B*K))*15;

p = radius*[
    exp(-30*pi/180*1j)
    exp(-15*pi/180*1j)
    exp(  0*pi/180*1j)
    exp( 15*pi/180*1j)
    exp( 30*pi/180*1j)
];

A_l = [
    0 1 0 0 0;
    0 0 0 0 0; 
    0 0 0 1 0;
    0 0 0 0 0;
  k_3 0 0 0 0;
];

B_l = [
    0   0;
    0   k_1;
    0   0;
    k_2 0;
    0   0
];

C_l = diag([1 1 1 1 1]);

L_l = place(A_l', C_l', p)';


%Kalman Filter

dt = 0.002;

A_kalman = [ 
    0 1 0 0 0 0;
    0 0 0 0 0 0;
    0 0 0 1 0 0;
    0 0 0 0 0 0;
    0 0 0 0 0 1;
  k_3 0 0 0 0 0;
];

B_kalman = [
    0   0;
    0   k_1;
    0   0;         
    k_2 0;
    0   0;
    0   0;
];

C_kalman = diag([1 1 1 1 0 1]);

D_kalman = 0;

continuous_system = ss(A_kalman, B_kalman, C_kalman, D_kalman);

discrete_system = c2d(continuous_system, dt);

Ad = discrete_system.A;
Bd = discrete_system.B;
Cd = discrete_system.C;

Rd = [
    0.00537608125247140,0.00363945863796865,0.0110560054583951,-0.00558128945733279,0,0.000758363474597500;
    0.00363945863796865,0.0112323776448364,0.0136578362008299,-0.00454735750511497,0,0.00653167879587958;
    0.0110560054583951,0.0136578362008299,0.100328027903180,-0.0110113032046944,0,0.00593802487779551;
    -0.00558128945733279,-0.00454735750511497,-0.0110113032046944,0.0165471220879775,0,0.000334218631353386;
    0,0,0,0,0.0000001,0;0.000758363474597500,0.00653167879587958,0.00593802487779551,0.000334218631353386,0,0.0593797778863446
];

a = 0.0001;

Qd = a*diag([1 1 1 1 1 1]);

x_hat_0 = 0*[
    1;
    1;
    1;
    1;
    1;
    1;
];

P_hat_0 = Rd*0;
